package FlashReader;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class SWF extends SwfTools{
	
	
	public int progress;
	public static ArrayList<Tag> EN_Tag = new ArrayList<Tag>(); //Wszystkie tagi
	public static HashMap<Integer, String> tags = new HashMap<Integer,String>(); //nazwy tagow
	public static ResourceBundle msgs; //wszelkie komunikaty, nazwy itp.
	public ByteBuffer bbuf; //dane calego swfa
	private Header header; //naglowek swf
	
	public static String [] tagsTab = {
				"End","ShowFrame","DefineShape","","PlaceObject","RemoveObject","DefineBits","DefineButton","JPEGTables","SetBackgroundColor","DefineFont","DefineText",
				"DoAction","DefineFontInfo","DefineSound","StartSound","","DefineButtonSound","SoundStreamHead","SoundStreamBlock","DefineBitsLossless","DefineBitsJPEG2","DefineShape2","DefineButtonCxform",
				"Protect","","PlaceObject2","","RemoveObject2","","","","DefineShape3","DefineText2","DefineButton2","DefineBitsJPEG3","DefineBitsLossless2","DefineEditText","","DefineSprite","","","","FrameLabel","",
				"SoundStreamHead2","DefineMorphShape","","DefineFont2","","","","","","","","ExportAssets","ImportAssets","EnableDebugger","DoInitAction","DefineVideoStream","VideoFrame","DefineFontInfo2","","EnableDebugger2",
				"ScriptLimits","SetTabIndex","","","FileAttributes","PlaceObject3","ImportAssets2","","DefineFontAlignZones","CSMTextSettings","DefineFont3","SymbolClass","Metadata","DefineScalingGrid","","","",
				"DoABC","DefineShape4","DefineMorphShape2","","DefineSceneAndFrameLabelData","DefineBinaryData","DefineFontName","StartSound2"
		};
	
	static{
		for(int i =0; i<tagsTab.length; i++){
			if (tagsTab[i].equals("")) 
				;
			else
				SWF.tags.put(i, tagsTab[i]);
		}
	}
	/**
	 * Inicjalizuje tablic tagami, a zdokumentacji Adobe str. 281
	 */

	
	private String getTag(int tag){
		return tags.get(tag);
	}

	public SWF(){
		super();
		Locale defLoc = Locale.getDefault();
		msgs = ResourceBundle.getBundle("Language", defLoc);
	}
	
	/**
	 * Wczytuje plik, wrzuca go do bufora i czyta naglowek swfa
	 * @param file
	 */
	public void readSwf(File  file){
		try {
			FileInputStream f =new FileInputStream(file);
			DataInputStream in = new DataInputStream(f);
			
			//alokuj odpowiedni ilo dla wczytanego pliku
			bbuf = ByteBuffer.allocate(in.available());
			//Ustawiam kolejno bitw na LITTLE ENDIAN
			bbuf.order(ByteOrder.LITTLE_ENDIAN);
		
			//wczytuj plik do buffora
			byte b[] = new byte[in.available()];
			in.readFully(b);
			bbuf.put(b);
			in.close();
			bbuf.rewind();
			//koniec
	
			//wczytuje 8 bajtow tagow poz 0-8
			header = getSwfHeader();
			//koniec
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Wczytuje wszystkie tagi swfa
	 */

public void getSwfTags(JProgressBar progressBar){

				while ( bbuf.position() < bbuf.capacity()){
				
					Double a = ((0.0+bbuf.position())/ bbuf.capacity())*100;
					a++;
					progressBar.setValue( a.intValue() );
					
					int pos = bbuf.position();
					
					int h =  unsignedShort(bbuf.getShort());
					int type = h >> 6;
					int length;
				
		        	if (((length = h & 0x3F) == 0x3F))
		        		length = bbuf.getInt();
		        	
					byte date[] = new byte[length];
					bbuf.get(date);
					
					//Jesli doABC to specjalizujemy klase DoABC
					if(type ==72 || type== 82){
						new DoABC(pos,type,date,bbuf,getThis());
						DoABC.doABCpos.add(pos);
						DoABC.doABCposId.add(tags.size()-1);
					}else{
						new Tag(pos,type,date,getThis());
					}
				}
	}

        
	/**
	 * Return this object
	 * @return
	 */
	private SWF getThis(){
		return this;
	}

	/**
	 * Zapisuje swf z wybrana kompresja, 0 - brak kompresji
	 * @param file
	 * @param level
	 */
	public void zapiszSWF(File file, int level){
		
		bbuf=buildSWF();
		bbuf.order(ByteOrder.LITTLE_ENDIAN);

		try {
			FileOutputStream f = new FileOutputStream(file);
			DataOutputStream out = new DataOutputStream(f);

			if (level!=0){ //jesli z kompresja
				
				kompresuj(level);
				out.write(bbuf.array());
				
			}else{ //bez kompresji
				out.write(bbuf.array());
			}
			 //gui.showInfo(msgs.getString("Isaved"));
			
			 out.close();
		
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	/**
	 * Pobiera naglowek
	 * @return
	 */
	public Header getSwfHeader(){
	
		header = new Header();
	
		bbuf.rewind();
		bbuf.order(ByteOrder.LITTLE_ENDIAN);
		
		//SWF CWS
		header.setSignature1(bbuf.get());
		header.setSignature2(bbuf.get());
		header.setSignature3(bbuf.get()); 
		
		//Wersja flasha
		header.setVersion(bbuf.get());

		//Rozmiar pliku swf
		header.setFileLength(unsignedInt(bbuf.getInt())) ;
	
		//Wymiary swf
		syncBits();
		int nBits = readUBits(5,bbuf);
		header.setXmin(readSBits(nBits,bbuf));
		header.setXmax(readSBits(nBits,bbuf));
		header.setYmin(readSBits(nBits,bbuf));
		header.setYmax(readSBits(nBits,bbuf));
		//Koniec wymiary swf

		//Klatki na sekund
		int frameRate = unsignedByte(bbuf.get())<<8|unsignedByte(bbuf.get());
		header.setFrameRate(frameRate);
		//Koniec klatki na sekund
		
		//Ilo klatek
		short frameCount = (bbuf.getShort());
		header.setFrameCount(unsignedShort(frameCount)) ;
		//Koniec ilo klatek
		return header;
	}
	
	/**
	 * Kompresuje dane
	 * @param level
	 * @throws Exception 
	 */
	public void kompresuj(int level) throws Exception{
		
		 byte[] output = new byte[bbuf.capacity()];
		 Deflater compresser = new Deflater(level);
		 byte doKompresji[] = Arrays.copyOfRange(bbuf.array(), 8, bbuf.capacity());//pomijam naglowek
		
		 if ( bbuf.array()[0] ==70 ){//jesli nie skompresowany
			
			 compresser.setInput(doKompresji);
			 compresser.finish();
			 int compressedDataLength = compresser.deflate(output);
			
			 byte [] tmp = Arrays.copyOfRange(bbuf.array(), 0,8);
			 tmp[0] = 67;
				
			//alokuj odpowiedni ilo dla wczytanego zdekompresowanego pliku
		     bbuf = ByteBuffer.allocate(compressedDataLength+8);
		     //Ustawiam kolejno bitw na LITTLE ENDIAN
		     bbuf.order(ByteOrder.LITTLE_ENDIAN);
		     
		     bbuf.put(tmp);
		     bbuf.put(Arrays.copyOf(output, compressedDataLength));
		     
		 }else { //jesli juz skompresowany to blad
			 throw new Exception(msgs.getString("Wcompress"));
		 }
	}
	
	/**
	 * Dekompresuje dane
	 * @throws Exception 
	 */
	public void dekompresuj() throws Exception{

		if (  bbuf.array()[0]==67){//jesli skompresowany
			
		     Inflater decompresser = new Inflater();
		     int size =header.getFileLength();
	
		     decompresser.setInput(bbuf.array(), 8, bbuf.capacity()-8);
		     byte[] result = new byte[size-8];
		 
		     try {
		         decompresser.inflate(result);
		     } catch (DataFormatException e1) {
		             e1.printStackTrace();
		     }
		 
		     decompresser.end(); 

		     byte [] headers = new byte[8];
		     bbuf.position(0);
		     bbuf.get(headers, 0, 8);
		     headers[0] = 70;
		     headers[1] = 87;
		     headers[2] = 83;
		     
			 //alokuj odpowiedni ilo dla wczytanego pliku
		     bbuf = ByteBuffer.allocate(size);
		     //Ustawiam kolejno bitw na LITTLE ENDIAN
		     bbuf.order(ByteOrder.LITTLE_ENDIAN);
				
			 bbuf.rewind();
		     bbuf.put(headers);
		     bbuf.put(result);
		       
		     //gui.showInfo(msgs.getString("decompressed"));
	       
		}else{
			throw new Exception(msgs.getString("Wdecompressed"));
		}
     
	}
	
	public Header getHeader() {
		return header;
	}

	public void setHeader(Header header) {
		this.header = header;
	}
	
	/**
	 * Drukuje wszystkie tagi
	 * @return
	 */
	public String printTags(){
		StringBuffer wynik= new StringBuffer();
		
		for(Tag t:EN_Tag){
			wynik.append("\nTag: " + t.getopcode() +", " +getTag(t.getopcode()) +
			", "+SWF.msgs.getString("length")+": " + t.getLength()+ ", "+msgs.getString("position")+": " + t.getPos());
		}
		return wynik.toString();
	}
	
	/**
	 * Liczy rozmiar wszystkich tagow
	 * @return
	 */
	public int getTagsLen(){
		int result=0;
		for (Tag t:EN_Tag ){
			result+=t.getLength();
			if(t.getLength()<61) result+=2;
			else  result+=6;
		}
		return result;
	}

	/**
	 * Generuje swfa z klas
	 * @return
	 */
	private ByteBuffer buildSWF(){
		ByteBuffer bbufHeader = header.getBytes();
		ByteBuffer bbuf;
		bbuf = ByteBuffer.allocate(getTagsLen()+bbufHeader.capacity());
		bbuf.order(ByteOrder.LITTLE_ENDIAN);
		header.setFileLength(bbuf.capacity());
		
		bbuf.put(bbufHeader);
		for (Tag t:EN_Tag ){
			bbuf.put(t.getBytes());
		}
		return bbuf;
	}

	
}
